unit Mainform;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DB, DBTables, StdCtrls, Mask, DBCtrls, ExtCtrls, 
  Grids, DBGrids, Mddbcomb;

type
  TForm1 = class(TForm)
    DataDemo: TDatabase;
    NavigatorProjects: TDBNavigator;

    Label1: TLabel;
    TableProjects: TTable;
    DataProjects: TDataSource;
    EditProjectName: TDBEdit;

    Label2: TLabel;
    TableCompanies: TTable;
    DataCompanies: TDataSource;
    LookupCompanyName: TmdDBLookupCombo;

    Label3: TLabel;
    TableManagersSorted: TTable;
    DataManagersSorted: TDataSource;
    LookupManagerAlphSort: TmdDBLookupCombo;
    ButtonReadOnly: TButton;

    Label7: TLabel;
    TableManagers: TTable;
    DataManagers: TDataSource;
    LookupManager: TmdDBLookupCombo;

    Label5: TLabel;
    TableManager1: TTable;
    DataManager1: TDataSource;
    LookupManagerCompany1: TmdDBLookupCombo;

    Label4: TLabel;
    ListManagers: TmdDBLookupList;
    TableManagers2: TTable;
    DataManagers2: TDataSource;

    Label6: TLabel;
    QueryManagers: TQuery;
    DataQueryManagers: TDataSource;
    LookupManagersSQL: TmdDBLookupCombo;
    procedure ButtonReadOnlyClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.ButtonReadOnlyClick(Sender: TObject);
begin
  LookupManagerAlphSort.ReadOnly:=not LookupManagerAlphSort.ReadOnly;
  if LookupManagerAlphSort.ReadOnly then ButtonReadOnly.Caption:='Edit'
                                    else ButtonReadOnly.Caption:='ReadOnly';
end;

procedure TForm1.FormCreate(Sender: TObject);
var TempStr: string[40];
    i: integer;
begin
  DataDemo.Connected:=false;
  TempStr:=ParamStr(0);
  while TempStr[length(TempStr)]<>'\' do dec(byte(TempStr[0]));
  DataDemo.Params.Values['SERVER NAME']:=TempStr;
  DataDemo.Connected:=true;
  for i:=0 to ComponentCount-1 do
    if Components[i].InheritsFrom(TDataSet) then
      with (Components[i] as TDataSet) do Active:=true;
end;

end.

